import pandas as pd
import numpy as np
import os

def calc_waiting_time(round, record_name, memo, test_round):
    file_path = os.path.join(os.getcwd(), "records", memo, record_name, test_round, "round_{}".format(round))
    file_list = os.listdir(file_path)
    avg_waiting_time = []
    for file in file_list:
        if file[-4:] == ".csv":
            waiting_time_df = pd.read_csv(os.path.join(file_path, file))
            waiting_time_list = []
            if "enter_time" not in waiting_time_df:
                continue
            for enter, leave in zip(waiting_time_df["enter_time"], waiting_time_df["leave_time"]):
                if not pd.isna(leave):
                    waiting_time_list.append(leave - enter)
                else:
                    waiting_time_list.append(3600.0 - enter)
            avg_waiting_time.append(np.mean(waiting_time_list))
    # print(np.mean(avg_waiting_time))
    return np.mean(avg_waiting_time)
        
calc_waiting_time(60, "anon_28_7_newyork_real_double.json_12_24_10_03_34_MOTSC", "MOTSC", "test_round")