import os
import pickle
import matplotlib.pyplot as plt
import numpy as np

inter_id = 0
inter_data_path = os.path.join(os.getcwd(), "offline_dataset", "Fixedtime", "anon_3_4_jinan_real_2500.json", "inter_data", "inter_{}".format(inter_id))
inter_data_files = os.listdir(inter_data_path)

plt.figure(figsize=[8, 4])
plt.subplot(1, 2, 1)
queue_length = []
for inter_data_file in inter_data_files:
    with open(os.path.join(inter_data_path, inter_data_file), "rb") as f:
        inter_data = pickle.load(f)
        queue_length.append(np.mean(inter_data[0]["lane_num_waiting_vehicle_in"]))
plt.plot(np.linspace(0, len(queue_length), len(queue_length)), queue_length)
    
inter_data_path = os.path.join(os.getcwd(), "test_dataset", "Fixedtime", "anon_3_4_jinan_real_2500.json", "inter_data", "inter_{}".format(inter_id))
plt.subplot(1, 2, 2)
queue_length = []
for inter_data_file in inter_data_files:
    with open(os.path.join(inter_data_path, inter_data_file), "rb") as f:
        inter_data = pickle.load(f)
        queue_length.append(np.mean(inter_data[0]["lane_num_waiting_vehicle_in"]))
        print(inter_data[0]["time_this_phase"])
plt.plot(np.linspace(0, len(queue_length), len(queue_length)), queue_length)
    
plt.savefig(os.path.join(os.getcwd(), "test_offline_data.jpg"))