import os
import pickle
import random

def copy_offline_dataset_ratio(method, traffic_flow, ratio):
    dataset_path =  os.path.join(os.getcwd(), "offline_dataset", method, traffic_flow)
    output_path = os.path.join(os.getcwd(), "offline_dataset", method, traffic_flow, str(int(ratio * 100)))
    output_data_path = os.path.join(output_path, "data")
    output_inter_data_path = os.path.join(output_path, "inter_data")
    if not os.path.exists(output_data_path):
        os.makedirs(output_data_path)
    if not os.path.exists(output_inter_data_path):
        os.makedirs(output_inter_data_path)
    inter_data = os.path.join(dataset_path, "inter_data")
    inter_dirs = os.listdir(inter_data)
    for inter_dir in inter_dirs:
        if not os.path.exists(os.path.join(output_inter_data_path, inter_dir)):
            os.makedirs(os.path.join(output_inter_data_path, inter_dir))
        inter_files = os.listdir(os.path.join(inter_data, inter_dir))
        sampled_inter_files = random.sample(inter_files, int(ratio * len(inter_files)))
        for file in sampled_inter_files:
            content = []
            with open(os.path.join(inter_data, inter_dir, file), "rb") as f:
                content = pickle.load(f)
            with open(os.path.join(output_data_path, file), "wb") as f:
                pickle.dump(content, f)
            with open(os.path.join(output_inter_data_path, inter_dir, file), "wb") as f:
                pickle.dump(content, f)
                
if __name__ == "__main__":
    copy_offline_dataset_ratio("Fixedtime", "anon_3_4_jinan_real_2500.json", 0.02)