from utils.offline_datafactory import DataFactory
from utils.utils import pipeline_wrapper, merge
from utils import config
import time
from multiprocessing import Process
import argparse
import os


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("-memo",       type=str,           default='benchmark_1001')
    parser.add_argument("-mod",        type=str,           default="Fixedtime")
    parser.add_argument("-eightphase",  action="store_true", default=False)
    parser.add_argument("-gen",        type=int,            default=1)
    parser.add_argument("-multi_process", action="store_true", default=True)
    parser.add_argument("-workers",    type=int,            default=3)
    parser.add_argument("-dataset",     type=str,   choices=['jinan', 'hangzhou', 'newyork'],    default='jinan')
    return parser.parse_args()


def main(in_args=None):

    if in_args.dataset == 'hangzhou':
        count = 3600 * 4
        road_net = "4_4"
        traffic_file_list = ["anon_4_4_hangzhou_real.json", 
                             "anon_4_4_hangzhou_real_5816.json"]
        template = "Hangzhou"
        num_rounds = 1
    elif in_args.dataset == 'jinan':
        count = 3600 * 2
        road_net = "3_4"
        # traffic_file_list = ["anon_3_4_jinan_real.json", "anon_3_4_jinan_real_2000.json",
        #                      "anon_3_4_jinan_real_2500.json"]
        traffic_file_list = ["anon_3_4_jinan_real_2500.json"]
        template = "Jinan"
        num_rounds = 1
    elif in_args.dataset == 'newyork':
        count = 3600 * 4
        road_net = "28_7"
        traffic_file_list = ["anon_28_7_newyork_real_double.json"]
        template = "NewYork"
        num_rounds = 1

    NUM_COL = int(road_net.split('_')[1])
    NUM_ROW = int(road_net.split('_')[0])
    num_intersections = NUM_ROW * NUM_COL
    print('num_intersections:', num_intersections)
    print(traffic_file_list)
    process_list = []
    for traffic_file in traffic_file_list:
        dic_traffic_env_conf_extra = {
            "CITYFLOW_MAX_TIME": 3600,
            "NUM_ROUNDS": num_rounds,
            "NUM_GENERATORS": in_args.gen,
            "NUM_AGENTS": 12,
            "NUM_INTERSECTIONS": num_intersections,
            "RUN_COUNTS": count,
            "MODEL_NAME": in_args.mod,
            "NUM_ROW": NUM_ROW,
            "NUM_COL": NUM_COL,
            "TRAFFIC_FILE": traffic_file,
            "ROADNET_FILE": "roadnet_{0}.json".format(road_net),
            "TRAFFIC_SEPARATE": traffic_file,
            "LIST_STATE_FEATURE": [
                "cur_phase",
                "time_this_phase",
                "lane_num_vehicle",
                "lane_num_waiting_vehicle_in",
                "traffic_movement_pressure_queue",
                "traffic_movement_pressure_queue_efficient",
                "lane_enter_running_part",
                "adjacency_matrix",
                "num_in_seg_attend"
            ],
            "DIC_REWARD_INFO": {
                "traffic_movement_pressure_queue_efficient": -0.25
            },
            "LIST_INFO_FEATURE": [
                "lane_num_waiting_vehicle_in",
            ]
        }

        if in_args.eightphase:
            dic_traffic_env_conf_extra["PHASE"] = {
                1: [0, 1, 0, 1, 0, 0, 0, 0],
                2: [0, 0, 0, 0, 0, 1, 0, 1],
                3: [1, 0, 1, 0, 0, 0, 0, 0],
                4: [0, 0, 0, 0, 1, 0, 1, 0],
                5: [1, 1, 0, 0, 0, 0, 0, 0],
                6: [0, 0, 1, 1, 0, 0, 0, 0],
                7: [0, 0, 0, 0, 0, 0, 1, 1],
                8: [0, 0, 0, 0, 1, 1, 0, 0]
            }
            dic_traffic_env_conf_extra["PHASE_LIST"] = ['WT_ET', 'NT_ST', 'WL_EL', 'NL_SL',
                                                        'WL_WT', 'EL_ET', 'SL_ST', 'NL_NT']

        dic_path_extra = {
            "PATH_TO_WORK_DIRECTORY": os.path.join(os.getcwd(), "test_dataset", "Fixedtime", traffic_file),
            "PATH_TO_DATA": os.path.join(os.getcwd(), "data", template, str(road_net)),
            "PATH_TO_ERROR": os.path.join(os.getcwd(), "errors", in_args.memo),
        }
        
        dic_agent_conf_extra = {
            "FIXED_TIME": [30, 30, 30, 30],
        }

        deploy_dic_agent_conf = merge(config.DIC_BASE_AGENT_CONF, dic_agent_conf_extra)
        deploy_dic_traffic_env_conf = merge(config.dic_traffic_env_conf, dic_traffic_env_conf_extra)
        deploy_dic_path = merge(config.DIC_PATH, dic_path_extra)

        data_factory = DataFactory(deploy_dic_agent_conf, deploy_dic_traffic_env_conf, deploy_dic_path)
        data_factory.train()

    return in_args.memo


if __name__ == "__main__":
    args = parse_args()

    main(args)

