import argparse
import os

from run_advanced_mplight import advanced_mplight_main
from run_dqn import dqn_main
from run_presslight import presslight_main
from run_attendlight import attendlight_main
from run_colight import colight_main

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("-memo",       type=str,           default='MOTSC')
    parser.add_argument("-mod",        type=str,           default="EfficientPressLight")
    parser.add_argument("-eightphase",  action="store_true", default=False)
    parser.add_argument("-gen",        type=int,            default=1)
    parser.add_argument("-multi_process", action="store_true", default=True)
    parser.add_argument("-workers",    type=int,            default=3)
    parser.add_argument("-dataset",     type=str,   choices=['jinan', 'hangzhou', 'newyork'],    default='jinan')
    parser.add_argument("-offline", type=str, choices=["Fixedtime", "MaxPressure"], default="Fixedtime")
    parser.add_argument("-data_size", type=str, choices=["20", "40", "60", "80", "100", ""], default="100")
    parser.add_argument("-transition", type=str, default="ONLINE")
    return parser.parse_args()

def main(in_args):
    test_transition = ["ONLINE", "SIMPLE", "MOPO", "MOTSC"]
    for one_transition in test_transition:
        in_args.transition = "MOTSC"
        if in_args.mod == "AdvancedMPLight":
            advanced_mplight_main(in_args)
        elif in_args.mod == "AdvancedDQN":
            dqn_main(in_args)
        elif in_args.mod == "EfficientPressLight":
            presslight_main(in_args)
        elif in_args.mod == "Attend":
            attendlight_main(in_args)
        elif in_args.mod == "EfficientColight":
            colight_main(in_args)
        exit()
        

if __name__ == "__main__":
    args = parse_args()
    main(in_args=args)
