import os
import time
import itertools

from utils.offline_dataset_distribution import DistributionTester

traffic_file = "anon_3_4_jinan_real_2500.json"
offline_data = "Fixedtime"

path_to_offline_dataset = os.path.join("test_dataset", offline_data, traffic_file, "data")
path_to_save_dir = os.path.join(os.getcwd(), "records", "test_distribution_" + time.strftime('%m_%d_%H_%M_%S', time.localtime(time.time())))

tester = DistributionTester(path_to_offline_dataset)

all_features = [#"lane_num_vehicle",
                "lane_num_waiting_vehicle_in",
                #"traffic_movement_pressure_queue",
                "traffic_movement_pressure_queue_efficient",
                "lane_enter_running_part"]

combination_features = itertools.combinations(all_features, 3)
for features in combination_features:
    tester.t_sne(features)
    tester.draw_distribution(path_to_save_dir)
    