
# command line used to call fast-downward, using limit.sh
PLANNER_CALL = "planner-scripts/fd-latest-clean -o"

# Search option used to find the optimal plan
OPTIMAL_SEARCH_OPTION = "'--search astar(lmcut())'" # The string needs to be inside ''

SATISFICING_SEARCH_OPTIONS = {
    "lama-first":"'--alias lama-first'",
}

HEURISTICS = {
    # relaxation-based admissible h
    'lmcut':'lmcut()',
    'hmax':'hmax()',
    # abstraction-based admissible h
    'merge_and_shrink':'merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50k,threshold_before_merge=1)',
    # relaxation-based inadmissible
    'ff':'ff()',
    'add':'add()',
    'cea':'cea()',
    # abstraction-based inadmissible
    # -- none found
    # blind
    'blind':'blind()',
}

COSTS = list(HEURISTICS.keys()) + [
    'h*',
    'zero',
    'ninf',
    'inf',
]


DOMAIN_TO_GENERATOR = {
    'blocksworld' : 'blocksworld-4ops',
    'logistics' : 'logistics',
    'satellite' : 'satellite',
}

TRAINING_LOGS_DIR = 'training_logs'
TRAINING_CKPT_DIR = 'training_ckpt'
TRAINING_JSON_DIR = 'training_json'

