#!/bin/bash -e

# echo the command line calls to run
tasks (){
    parallel echo python generate_datum.py -o data train blocksworld ::: {1..38} ::: {5..16} # 38x12 = 456
    parallel echo python generate_datum.py -o data val   blocksworld ::: {1..11} ::: {5..16} # 11x12 = 132
    parallel echo python generate_datum.py -o data test  blocksworld ::: {1..11} ::: {5..16} # 11x12 = 132
    parallel echo python generate_datum.py -o data plan  blocksworld ::: {1..6} ::: {5..22} | sort -R | head -n 100

    parallel echo python generate_datum.py -o data train logistics ::: {1..4} ::: {1..4} ::: {1..6} ::: {1..4} ::: {3..6} ::: 5 # 4x4x6x4x4x1=1536
    parallel echo python generate_datum.py -o data val   logistics ::: 1      ::: {1..4} ::: {1..6} ::: {1..4} ::: {3..6} ::: 5 # 4x6x4x4x1=384
    parallel echo python generate_datum.py -o data test  logistics ::: 1      ::: {1..4} ::: {1..6} ::: {1..4} ::: {3..6} ::: 5 # 4x6x4x4x1=384
    parallel echo python generate_datum.py -o data plan  logistics ::: 1      ::: {3..6} ::: {3..8} ::: {3..6} ::: {5..8} ::: 5  | sort -R | head -n 100

    parallel echo python generate_datum.py -o data train satellite ::: {1..4} ::: {1..6} ::: 3 ::: {3..6} ::: 7 10 15 ::: {3..6} # 4x6x4x3x4=1152
    parallel echo python generate_datum.py -o data val   satellite ::: 1      ::: {1..6} ::: 3 ::: {3..6} ::: 7 10 15 ::: {3..6} # 6x4x3x4=288
    parallel echo python generate_datum.py -o data test  satellite ::: 1      ::: {1..6} ::: 3 ::: {3..6} ::: 7 10 15 ::: {3..6} # 6x4x3x4=288
    parallel echo python generate_datum.py -o data plan  satellite ::: 1      ::: {2..7} ::: {3..4} ::: {4..7} ::: 8 11 16 ::: {4..7} | sort -R | head -n 100
}

# perform a list of commands in parallel
tasks | parallel --bar
