#!/bin/bash

timestamp=$(date +%Y%m%d%H%M)
max_evaluations=10000

# echo the command line calls to run
tasks (){
    domain=$1
    # note: "'{1}'" protects paths that contain whitespaces.

    parallel echo ./plan.py -v --max-evaluations ${max_evaluations} \
             ::: ff \
             ::: data/${domain}/plan/*.pddl

}

# pass the commands to a job scheduler like:
# ./plan_all.sh | parallel [job submission commands...]

tasks blocksworld

tasks satellite

tasks logistics
