#!/usr/bin/env python3

import os
import subprocess
import argparse
import logging
import glob
import tqdm
import json
import pandas as pd
import multiprocessing as mp
from matplotlib import pyplot as plt

pd.set_option('display.max_columns', None)
pd.set_option('display.width', None)
pd.set_option('display.max_info_columns', 500)

import pddlsl.stacktrace

parser = argparse.ArgumentParser()

parser.add_argument("root", nargs="?", default="data", help=f"directory containing domain directories.")
parser.add_argument("output", nargs="?", default="results_planning.csv", help=f"directory containing domain directories.")

args = parser.parse_args()

def load(logfile):
    with open(logfile,"r") as f:
        try:
            record = json.load(f)
        except json.decoder.JSONDecodeError:
            print(f"malformed json file: {logfile}")
            return None

    # record = {
    #     k:v
    #     for k, v in record.items()
    #     if not isinstance(v, list)
    # }
    if "plan" in record:
        record["solved"] = True
    else:
        record["solved"] = False
    return pd.Series(record)


def load_files(p):
    print("\nlisting logfiles...")
    logfiles = glob.glob(os.path.join(args.root, "*", "plan", "*.logs", "*.json"))
    series_list = []
    # for logfile in tqdm.tqdm(logfiles):
    #     series_list.append(pd.Series(load(logfile)))
    print("\nloading logfiles...")
    with tqdm.tqdm(total=len(logfiles)) as pbar:
        for r in p.imap_unordered(load,logfiles,chunksize=mp.cpu_count()):
            if r is not None:
                series_list.append(r)
            pbar.update()

    df = pd.DataFrame(series_list)
    return df




def inc(value=None):
    if value is not None:
        inc.c = value-1
    inc.c += 1
    return inc.c
inc.c = 0

translations = {
    "original" : ("modified",inc()),
}

def translate(name):
    name = str(name)
    if name.endswith("-strips"):
        return name[:-7]
    elif name in translations:
        return translations[name][0]
    else:
        return name

def order(name):
    if isinstance(name, float):
        return name
    elif isinstance(name, int):
        return name
    name = str(name)
    if name in translations:
        return translations[name][1]
    else:
        return 0



if __name__ == "__main__":
    try:
        print(f"running with {len(os.sched_getaffinity(0))} processes")
        with mp.Pool(len(os.sched_getaffinity(0))) as p:
            df = load_files(p)
            df.to_csv(args.output)
    except:
        stacktrace.format()

