import sklearn.metrics as skmetr
import numpy as np

clean = np.load('results/inception_clean.npy')
adv = np.load('results/inception_pgd.npy')
scores_all = np.concatenate([adv, clean])

true_labels_adv = np.array([1] * len(adv))
true_labels_clean = np.array([0] * len(clean))
true_labels_all = np.concatenate([true_labels_adv, true_labels_clean])

fpr, tpr, thresholds = skmetr.roc_curve(true_labels_all, scores_all)
auc = skmetr.auc(fpr, tpr)
print(str(auc))
