import json

class BaseServer:
    def __init__(self, env, calculate_metrics=None):
        self._env = env
        self._stats = {}
        self._calculate_metrics = calculate_metrics
        if self._calculate_metrics is not None:
            self._stats['metrics'] = []

    def prepare(self):
        raise NotImplementedError()

    def step(self):
        raise NotImplementedError()

    def run(self):
        yield self._env.process(self.prepare())
        i = 0
        while True:
            if self._calculate_metrics is not None:
                metric_value, save_path_temporal, config = self._calculate_metrics(self._env, i, self.get_point())
                if metric_value is not None:
                    self._stats['metrics'].append(metric_value)
                    
                if save_path_temporal is not None:
                    stats = self._stats
                    stats["params"] = config
                    with open(save_path_temporal, 'w') as f:
                        json.dump(stats, f, indent=4)
                    print(f"Temporal results saved to {save_path_temporal}")
                    
            yield self._env.process(self.step())
            i += 1

    def get_point(self):
        return self._point

    def get_stats(self):
        return self._stats
