import argparse
import yaml
import os
import glob
import time
from simulator.run_experiment import train_logistic_regression, load_mnist_binary

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Train Logistic Regression on MNIST (binary classification) and save experiment results.")
    parser.add_argument('--output_dir', type=str, required=True, help='Directory to save experiment results')
    parser.add_argument('--configs_dir', type=str, required=True, help='Directory with configs')
    args = parser.parse_args()

    results_dir = os.path.join(args.output_dir, "results")

    # Create output directory if it doesn't exist
    os.makedirs(results_dir, exist_ok=True)
    
    X, y, X_t, y_t, num_classes = load_mnist_binary()

    # Iterate through all yaml files in configs directory
    for config_file in glob.glob(os.path.join(args.configs_dir, "*.yaml")):
        start_time = time.time()
        
        # Get config filename without extension to use as prefix
        config_prefix = os.path.splitext(os.path.basename(config_file))[0]
        
        # Construct output path using prefix
        output_path = os.path.join(results_dir, f"{config_prefix}_results.json")
        
        print(f"Running experiment for config: {config_file}")
        print(f"Results will be saved to: {output_path}")
        
        # Load and run config
        config = yaml.safe_load(open(config_file))
        train_logistic_regression(X, y, X_t, y_t, num_classes, save_path=output_path, config=config)
        print(f"Completed experiment for {config_file} in {time.time() - start_time} seconds\n")
