import pandas as pd
from pathlib import Path


def get_non_anouncement_days(
    companyAllTransactionDf, announcementDayWithWindowedInvestorDf
):
    company_trade_days = pd.unique(companyAllTransactionDf["TradeDay"])
    Announcement_days = pd.to_datetime(
        announcementDayWithWindowedInvestorDf["AnnouncementDay"].unique()
    )

    df = pd.DataFrame({"TradeDay": company_trade_days})
    indexes_to_remove = set()

    for announcement in Announcement_days:
        if announcement in df["TradeDay"].values:
            idx = df[df["TradeDay"] == announcement].index[0]
            indexes_to_remove.update(range(max(0, idx - 4), idx + 1))

    df_filtered = df.drop(indexes_to_remove).reset_index(drop=True)
    non_announcement_trade_days = df_filtered["TradeDay"].tolist()

    companyNonAnnouncementTransactionDf = companyAllTransactionDf[
        companyAllTransactionDf["TradeDay"].isin(non_announcement_trade_days)
    ]

    return companyNonAnnouncementTransactionDf


def baseline_model(
    CompanyID, announcementDayWithWindowedInvestorDf, companyAllTransactionDf
):
    csv_path = Path(
        f"Learning_transmission_probs/Data/Company_Baseline_Probabilities/{CompanyID}_baseline_trade_probabilities.csv"
    )

    if csv_path.exists():
        print(
            f"Baseline probabilities for {CompanyID} already exists in {csv_path}. Reading data..."
        )
        return pd.read_csv(csv_path)

    print(
            f"Computing Baseline probabilities for {CompanyID}."
        )
    transaction_df = get_non_anouncement_days(
        companyAllTransactionDf, announcementDayWithWindowedInvestorDf
    )


    Company_unique_trade_days = pd.unique(transaction_df["TradeDay"])

    Company_Day_level_price_average_DF = (
        transaction_df.groupby("TradeDay", as_index=False)["Price"]
        .mean()
        .reset_index(drop=True)
    )

    unique_investors_transaction_data = transaction_df["InvestorID_EC"].unique()

    investor_trade_prob = []

    for investor in list(unique_investors_transaction_data):
        current_inv_filtered_df = transaction_df[
            transaction_df["InvestorID_EC"] == investor
        ]
        unique_trade_days_current_inv = pd.unique(current_inv_filtered_df["TradeDay"])

        Current_inv_vol_price_DF = current_inv_filtered_df.groupby(
            "TradeDay", as_index=False
        ).agg({"Volume": "sum", "Price": "mean"})

        number_of_profitable_trade = 0
        number_of_loss_trade = 0
        number_of_volume_0_trade = 0

        for _, row in Current_inv_vol_price_DF.iterrows():
            trade_day = row["TradeDay"]
            current_price = row["Price"]
            volume = row["Volume"]
            future_price = current_inv_filtered_df[
                current_inv_filtered_df["TradeDay"] == trade_day
            ].iloc[0]["P_week"]

            trade_day_index = Company_Day_level_price_average_DF[
                Company_Day_level_price_average_DF["TradeDay"] == trade_day
            ].index

            if not trade_day_index.empty:
                if volume == 0:
                    number_of_volume_0_trade += 1
                elif (current_price < future_price and volume > 0) or (
                    current_price > future_price and volume < 0
                ):
                    number_of_profitable_trade += 1
                else:
                    number_of_loss_trade += 1

        profitable_trade_prob = number_of_profitable_trade / len(
            Company_unique_trade_days
        )
        loss_trade_prob = number_of_loss_trade / len(Company_unique_trade_days)
        no_trade_prob = 1 - (profitable_trade_prob + loss_trade_prob)

        investor_trade_prob.append(
            {
                "InvestorID": investor,
                f"Inv{CompanyID}TradeDays": len(unique_trade_days_current_inv),
                "ProfitTradeDays": number_of_profitable_trade,
                "LossTradeDays": number_of_loss_trade,
                "volume0trade": number_of_volume_0_trade,
                "ProfitTradeProb": profitable_trade_prob,
                "LossTradeProb": loss_trade_prob,
                "NoTradeProb": no_trade_prob,
            }
        )

    investor_trade_prob_df = pd.DataFrame(investor_trade_prob)
    csv_path.parent.mkdir(parents=True, exist_ok=True)
    investor_trade_prob_df.to_csv(csv_path, index=False)

    return investor_trade_prob_df
