from dataclasses import dataclass


@dataclass
class ExperimentConfig:

    trade_options: tuple = (1, -1, 0)

    information_pathway_restart_probability: float = 0.5

    number_of_information_cascades_for_bootstrap_observed = 8
    number_of_classification_vectors = 50

    observed_data_class_label = 0
    simulated_data_class_label = 1


@dataclass
class TotalConfig(ExperimentConfig):

    random_seed: int = 10

    experiment_count: int = 3

    graph_edge_fraction: float = 0.04
    graph_node_count: int = 100
