
def prepare_inferred_table(df):
   
    df.rename(columns={'Is_non_announcement_period_computation': 'Announcement_period'}, inplace=True)
    df['Announcement_period'] = df['Announcement_period'].replace({
        False: 'Announcement_period',
        True: 'non_Announcement_period'
    })

    result = df.groupby(['Company', 'Announcement_period'])[['P_hat', 'Q_hat', 'Accuracy']].agg({
        'P_hat': ['mean', 'std'],
        'Q_hat': ['mean', 'std'],
        'Accuracy': 'mean'
    }).reset_index()

    # Rename columns to flatten before pivoting
    result.columns = ['Company', 'Announcement_period', 'P_hat_mean', 'P_hat_std', 'Q_hat_mean', 'Q_hat_std', 'Accuracy_mean']

    pivot_df = result.pivot(index='Company', columns='Announcement_period')

    # Flatten MultiIndex columns: e.g., ('P_hat_mean', 'Announcement_period') → 'P_hat_mean_Announcement_period'
    pivot_df.columns = [f'{col[0]}_{col[1]}' for col in pivot_df.columns]

    # Example list of expected columns based on the new naming convention
    ordered_columns = [
        'P_hat_mean_Announcement_period', 'Q_hat_mean_Announcement_period', 'Accuracy_mean_Announcement_period',
        'P_hat_mean_non_Announcement_period', 'Q_hat_mean_non_Announcement_period', 'Accuracy_mean_non_Announcement_period'
    ]

    print("Available columns:", pivot_df.columns.tolist())
    print("Expected columns:", ordered_columns)


    pivot_df = pivot_df[ordered_columns]

    pivot_df['p_hat_ratio'] = pivot_df['P_hat_mean_Announcement_period'] / pivot_df['P_hat_mean_non_Announcement_period']
    pivot_df['q_hat_ratio'] = pivot_df['Q_hat_mean_Announcement_period'] / pivot_df['Q_hat_mean_non_Announcement_period']

    pivot_df.rename(columns={
        'P_hat_mean_Announcement_period': 'Ann_p̂',
        'Q_hat_mean_Announcement_period': 'Ann_q̂',
        'Accuracy_mean_Announcement_period': 'Ann_Accuracy',
        'P_hat_mean_non_Announcement_period': 'Non_Ann_p̂',
        'Q_hat_mean_non_Announcement_period': 'Non_Ann_q̂',
        'Accuracy_mean_non_Announcement_period': 'Non_Ann_Accuracy',
        'p_hat_ratio': 'p̂_ratio',
        'q_hat_ratio': 'q̂_ratio'
    }, inplace=True)

    pivot_df.reset_index(inplace=True)
    return pivot_df
