import numpy as np
from sklearn.svm import SVC
from sklearn.metrics import accuracy_score
from sklearn.model_selection import GridSearchCV


node_best_params = {}


def hyper_parameter_optimise_investor_level(
    observed_feature_vector, simulated_feature_vector
):

    n_train_feature_vectors = 3 * len(observed_feature_vector) // 5

    train_feature_vectors_obs = observed_feature_vector[:n_train_feature_vectors]
    train_feature_vectors_sim = simulated_feature_vector[:n_train_feature_vectors]
    test_feature_vectors_obs = observed_feature_vector[n_train_feature_vectors:]
    test_feature_vectors_sim = simulated_feature_vector[n_train_feature_vectors:]
    X_train = np.concatenate(
        (
            [item[:3] for item in train_feature_vectors_obs],
            [item[:3] for item in train_feature_vectors_sim],
        ),
        axis=0,
    )
    y_train = np.concatenate(
        (
            [item[3] for item in train_feature_vectors_obs],
            [item[3] for item in train_feature_vectors_sim],
        ),
        axis=0,
    )
    X_test = np.concatenate(
        (
            [item[:3] for item in test_feature_vectors_obs],
            [item[:3] for item in test_feature_vectors_sim],
        ),
        axis=0,
    )
    y_test = np.concatenate(
        (
            [item[3] for item in test_feature_vectors_obs],
            [item[3] for item in test_feature_vectors_sim],
        ),
        axis=0,
    )

    svm = SVC()
    param_grid = {
        "C": [1, 10, 100, 1000],
        "kernel": ["linear", "rbf", "poly"],
        "gamma": [0.01, 0.1, 1],
    }

    grid_search = GridSearchCV(svm, param_grid, cv=5, scoring="accuracy")
    grid_search.fit(X_train, y_train)
    best_hyper_param = grid_search.best_params_

    best_model = grid_search.best_estimator_
    y_pred = best_model.predict(X_test)

    return best_hyper_param, accuracy_score(y_test, y_pred)


def hyper_parameter_optimise(observed_feature_vector_DF, simulated_feature_vector_DF):

    classification_accuracies_for_current_sim = []
    for inv in range(0, len(observed_feature_vector_DF)):
        observed_inv_features = observed_feature_vector_DF.iloc[inv]
        simulated_inv_features = simulated_feature_vector_DF.iloc[inv]
        best_hyper_parameter_current_inv, accuracy_current_inv = (
            hyper_parameter_optimise_investor_level(
                observed_feature_vector=observed_inv_features.tolist(),
                simulated_feature_vector=simulated_inv_features.tolist(),
            )
        )
        node_best_params[f"{inv}"] = best_hyper_parameter_current_inv
        classification_accuracies_for_current_sim.append(accuracy_current_inv)
    return classification_accuracies_for_current_sim, node_best_params
