from dataclasses import dataclass


@dataclass
class ExperimentConfig:

    symtptom_options: tuple = (1, -1, 0)
    non_activated_entity_symptom_probs: tuple = (0.25, 0.25, 0.5)  # q_baseline

    # number is Independent Cascades (IC)
    number_of_propagation_for_synthetic_graph = 300
    number_of_propagation_for_empirical_graph = 30

    number_of_classification_vectors = 50

    observed_data_class_label = 0
    simulated_data_class_label = 1


@dataclass
class TotalConfig(ExperimentConfig):
    random_seed: int = 10
    empirical_seeds = [1007314, 1003293, 1004153, 1007142, 1009743, 1004340, 1013931, 1003169, 1015236, 1009641, 1001454, 1008147, 1003049, 1005158, 1011023, 1008123, 1011029, 1002580, 1012535, 1008021, 1004532, 1002848, 1002582, 1014355, 1007608, 1008920, 1006232, 1006887, 1013317, 1005182, 1014299, 1003748, 1016576, 1005607, 1008195, 1001840, 1005685, 1002377, 1011868, 1002208, 1013386, 1002470, 1007554, 1005449, 1013861, 1007362]
    graph_node_count: int = 100  # for synthetic data
