import os
import pandas as pd

def generate_q_hat_summaries(resultDF_path: str, output_dir: str, classifier_name:str, feature_type:str):
    resultDF = pd.read_csv(resultDF_path)


    unique_qs = sorted(resultDF['GT_Q'].unique())
    for q_val in unique_qs:
        df_q = resultDF[resultDF['GT_Q'] == q_val]

        grouped = df_q.groupby('GT_P').agg(
            P_hat_mean=('P_hat', 'mean'),
            P_hat_std=('P_hat', 'std'),
            Q_hat_mean=('Q_hat', 'mean'),
            Q_hat_std=('Q_hat', 'std'),
            MSE_avg=('MSE_PQ', 'mean'),
            Accuracy_avg=('Accuracy', 'mean')
        ).reset_index()

        grouped['P_hat_mean'] = grouped['P_hat_mean'].round(2)
        grouped['Q_hat_mean'] = grouped['Q_hat_mean'].round(2)

        grouped.columns = pd.MultiIndex.from_arrays([
            [f"GT_Q = {q_val}"] * len(grouped.columns),
            grouped.columns
        ])

        grouped.to_csv(os.path.join(output_dir, f"q_{q_val}_summary_{classifier_name}_classifier_{feature_type}_features.csv"), index=False)
