import networkx as nx


def create_graph(node_count=100, seed=5, graph_type="Tree", df=None):

    if graph_type != "Insiders_network":
        if graph_type == "Tree":
            graph = nx.balanced_tree(r=2, h=10)  # r=2 (binary tree), h=6 (depth 6)
            graph = graph.subgraph(sorted(graph.nodes())[:100]).copy()
        elif graph_type == "Loopy":
            graph = nx.barabasi_albert_graph(n=node_count, m=2, seed=10)
        graph = graph.to_directed()

    else:
        graph = nx.DiGraph()
        for _, row in df.iterrows():
            graph.add_edge(row["source_id"], row["target_id"])

    print("Graph type", graph_type)
    print("Total nodes", graph.number_of_nodes())
    print("Edges for graph", graph.number_of_edges())


    return graph
