# Multi-Step Generalized Policy Improvement

This is the code for reproducing the experiments in the paper:
"Multi-Step Generalized Policy Improvement by Leveraging Approximate Models"

## Installation

To install the dependencies, run:
```
pip install -e .
```

## Running the experiments

### Train

For training the policies, run the following commands:

FourRoom
```
python experiments/gpi_fourroom.py --seed=1
```

Reacher
```
python experiments/jax_gpi_reacher.py --seed=1
```

FetchPush
```
python experiments/jax_gpi_push.py --seed=1
```

### Evaluate

For evaluating the policies, run the following commands:

FourRoom
```
python experiments/eval_gpi_fourroom.py
```

Reacher
```
python experiments/eval_gpi_reacher.py
```

FetchPush
```
python experiments/eval_gpi_push.py
```

The results will be saved in the `results` folder as `.npy` files containing matrices of shape `(num_seeds,num_tasks)`.