from setuptools import setup

REQUIRED = ['numpy>=1.21', 
            'torch', 
            'optax',
            'flax==0.6.7',
            'orbax==0.1.6',
            'cvxpylayers',
            'gymnasium>=0.27',
            'mo-gymnasium',
            'cvxpy', 
            'rliable',
            'wandb', 
            'pymoo', 
            'seaborn', 
            'pandas', 
            'fire', 
            'scipy', 
            'pycddlib']

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='gpi',
    version='0.1',
    packages=['gpi',],
    install_requires=REQUIRED,
    long_description=long_description,
    license="MIT",
    description='Code for Multi-Step Generalized Policy Improvement.'
)
