
METHOD_TYPE='DRL'             # method type, can be DRL, BER, ER, AGEM, MULTS, RMARGIN                  

TASK_TYPE='split'
RPATH='./results/'
DATASET='cifar10'
DPATH='./data/'               # data file path
NTASKS=5                      # number of tasks

SEED=0                        # start seed
RUNS=10                       # number of runs = RUNS - SEED

CORESET_SIZE=2000             # memory buffer size
FBDGT='True'                  # fixed budget of memory cost or not
TRAIN_SIZE=3000               # training set size
BATCH_SIZE=1                  # batch size of current data
BITER=1                       # number of iterations on each batch  
B=10                          # training batch size
MEM_BSIZE=256                 # reference batch size for A-GEM
LR=0.1                        # learning rate
GRAD='sgd'  
CTYPE='drl'                   # class type
LDISC=0.                      # lambda_DR
ALPHA=.1                      # DRL alpha
DISC='False'                  # enable DRL or not
ER='BER0'                     # choose EM strategy, can be ER, BER0(standalone BER), BER2
NTYPE='resnet18'              # net type
MULTA=2.                      # MultiSim alpha
MULTB=40.                     # MultiSim beta
MULTL=0.5                     # MultiSim lamb
RBETA=0.6
RGAMMA=0.2
PRHO=0.2
STRGH=0.001                   # strength


if [ "$METHOD_TYPE" = "DRL" ]; then
    LDISC=0.0002
    DISC='True'
    ER='BER2'

elif [ "$METHOD_TYPE" = "ER" ]; then
    ER='ER'

elif [ "$METHOD_TYPE" = "AGEM" ]; then
    CTYPE='agem'

elif [ "$METHOD_TYPE" = "MULTS" ]; then
    CTYPE='multisim'
    ER='BER2'
    STRGH=2.

elif [ "$METHOD_TYPE" = "RMARGIN" ]; then
    CTYPE='rho_margin'
    ER='BER2'
    STRGH=0.0001

# else test standalone BER
fi



while [ $SEED -lt $RUNS ]
do

	echo $SEED
    python test.py --data_path $DPATH --result_path $RPATH --task_type $TASK_TYPE --num_tasks $NTASKS \
            --dataset $DATASET --epoch 1 --coreset_size $CORESET_SIZE --fixed_budget $FBDGT \
            --coreset_mode ring_buffer --batch_size $BATCH_SIZE --train_size $TRAIN_SIZE \
            --test_size -1 --cl_type $CTYPE --B $B --learning_rate $LR --grad_type $GRAD --net_type $NTYPE \
            --batch_iter $BITER --discriminant $DISC --ER $ER --lambda_disc $LDISC --dis_alpha $ALPHA \
            --mem_bsize $MEM_BSIZE --seed $SEED --mults_alpha $MULTA --mults_beta $MULTB --mults_lamb $MULTL \
             --strength $STRGH --rho 1 --r_beta $RBETA --r_gamma $RGAMMA --r_prob $PRHO --cuda 1
            
    ((SEED++))
done
