#!/bin/bash
SBATCH --job-name=my_job            

python ../data/prepare_data.py --all_sample_num=20000

python 0generate_embd.py \
 --model_path="/root/qwen 0.5B/Qwen/Qwen2.5-0.5B-Instruct" \
 --test_file="/root/main_data/data/train_safe_token_sample_num20000.json" \
 --out_path="/root/safe_proj/gen_embd/qwen_0.5b_emb_res_20000.pt" \
 --batch_size=256 

 python 0generate_embd.py \
 --model_path="/root/model_cache/hub/Qwen/Qwen7B" \
 --test_file="/root/main_data/data/train_safe_token_sample_num20000.json" \
 --out_path="/root/safe_proj/gen_embd/qwen2.5-7b_emb_res_20000.pt" \
 --batch_size=256 

python 1train_model.py \
 --data_path='/root/safe_proj/gen_embd/qwen2.5-7b_emb_res_20000.pt' \
 --epochs=300 \
 --batch_size=256 \
 --learning_rate=1e-3 \
 --test_split=0.2

 python 1train_model.py \
 --data_path='/root/safe_proj/gen_embd/qwen2.5-1.5b_emb_res_20000.pt' \
 --epochs=100 \
 --batch_size=256 \
 --learning_rate=1e-3 \
 --test_split=0.2

  python 1train_model.py \
 --data_path='/root/safe_proj/gen_embd/qwen_0.5b_emb_res_20000.pt' \
 --epochs=100 \
 --batch_size=256 \
 --learning_rate=1e-3 \
 --test_split=0.2

python 2generate_predict_test_imp.py \
 --model_path="/root/model_cache/hub/Qwen/Qwen7B" \
 --test_file="/root/safe_proj/data/test_safe_token.json" \
 --out_path="/root/safe_proj/gen_embd/qwen2.5-7b_emb_res_20000.pt" \
 --safe_model="/root/safe_proj/gen_embd/qwen2.5-7b_emb_res_20000_cosine_similarity_net.pt"\
 --save_path="/root/safe_proj/gen_embd/7b_safe_model_pred.json" \
 --batch_size=256

 python 2generate_predict_test_imp.py \
 --model_path="/root/qwen1.5b" \
 --test_file="/root/safe_proj/data/test_safe_token.json" \
 --out_path="/root/safe_proj/gen_embd/qwen2.5-1.5b_emb_res_20000.pt" \
 --safe_model="/root/safe_proj/gen_embd/qwen2.5-1.5b_emb_res_20000_cosine_similarity_net.pt"\
 --save_path="/root/safe_proj/gen_embd/1b_safe_model_pred.json" \
 --batch_size=256

python 3generate_result_test_slm_imp.py \
 --model_path="/root/model_cache/hub/Qwen/Qwen7B" \
 --test_file="/root/safe_proj/gen_embd/1b_safe_model_pred.json" \
 --output_path="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_7b_generate.json" \
 --batch_size=64

 python 3generate_result_test_slm_imp.py \
 --model_path="/root/qwen1.5b" \
 --test_file="/root/safe_proj/gen_embd/1b_safe_model_pred.json" \
 --output_path="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_1b_generate.json" \
 --batch_size=256

python -u 4merge_result_imp.py \
 --path1="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_0.5b_generate.json" \
 --path2="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_1bp_generate.json" \
 --output_path="/root/safe_proj/gen_embd/results_qwen/safe_0.5b_1b_generate.json"

 python -u 4merge_result_imp.py \
 --path1="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_1b_generate.json" \
 --path2="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_7b_generate.json" \
 --output_path="/root/safe_proj/gen_embd/results_qwen/safe_1b_7b_generate_auto_tau.json"\
 --api_key="xxxxx"

python -u 5Eval.py --final_path="/root/safe_proj/gen_embd/results_qwen/safe_model_pred_1b_generate.json"
