def add_model_config(parser):
    #models: lrw classifier
    parser.add_argument('--model_name', help='model', type=str, default="lrw")
    #gcn gat
    parser.add_argument('--backbone', help='gnn backbone', type=str, default="gat")
    parser.add_argument('--num_layers', help='number of gnn layers', type=int, default=4)
    parser.add_argument('--dropout', help='drop out of gnn model', type=float, default=0.3)
    parser.add_argument('--hidden_dim', help='hidden units', type=int, default=256)
    parser.add_argument('--edge_dim', help='hidden units of linear-based model in edge-level tasks', type=int, default=256)
    parser.add_argument('--prop_steps', help='prop steps', type=int, default=3)
    parser.add_argument('--r', help='symmetric normalized unit', type=float, default=0.5)
    parser.add_argument('--node_q', help='the imaginary part of the complex unit in node-level tasks', type=float, default=0.05)
    parser.add_argument('--edge_q', help='the imaginary part of the complex unit in edge-level tasks', type=float, default=0.05)
    # gat
    parser.add_argument('--num_heads', help='number of attention', type=int, default=4)
    # directed digcn digcnappr digcnib model
    parser.add_argument('--ppr_alpha', help='ppr approxmite symmetric adj unit', type=float, default=0.1)
    # scalable gbp model
    parser.add_argument('--message_alpha', help='weighted message operator', type=float, default=0.5)
    # spatial mixed path aggregation: dipma
    parser.add_argument('--neighbor_hops', help='number of hops to consider', type=int, default=5)
    # spectral filter order: mgc
    parser.add_argument('--filter_order', help='order of filter process', type=int, default=10)
    # spatial directed graph auto encoder: nste
    parser.add_argument('--nste_alpha', help='propagation coefficient of nste', type=float, default=0.4)
    parser.add_argument('--nste_beta', help='propagation coefficient of nste', type=float, default=0.2)
    # spatial directed heterophilic graph gnn: dirgnn
    parser.add_argument('--dirgnn_alpha', help='direction weight of dirgnn', type=float, default=0.5)
    # spatial directed graph hyperbolic gnn: dhypr
    parser.add_argument('--dhypr_proximity', help='largest order of proximity matrix', type=int, default=2)
    # spectral 
    parser.add_argument('--poly_order', help='the order of polynomial', type=int, default=3)
    # spectral polyconv model
    parser.add_argument('--init_poly_coeff', help=' the parameter to initialize polynomial coefficients', type=float, default=1)
    # spectral gprgnn model
    parser.add_argument('--gpr_alpha', help='propagation class for ppr-link GPR_GNN', type=float, default=0.1)
    # spectral universal graph contrastive learning
    parser.add_argument('--ugcl_augment', help='graph augment ratio', type=float, default=0.1)
    parser.add_argument('--loss_weight', help='contrastive_loss_weight', type=float, default=0.2)
    # spectral directed graph contrastive learning
    parser.add_argument('--curr_type', help='curr_type', type=str, default="log")
    # graph contrastive learning
    parser.add_argument('--contrastive_batch', help='contrastive loss batch', type=int, default=1024)
    parser.add_argument('--temp', help='temperature in contrastive loss', type=float, default=0.5)
    parser.add_argument('--pro_dim', help='projection units', type=int, default=64)
    # random walk
    parser.add_argument('--walk_time', help='walks per node', type=int, default=5)
    parser.add_argument('--walk_len', help='length per walk', type=int, default=4)
    # directed random walk
    parser.add_argument('--walk_cof', help='coefficient', type=float, default=0.8)
    parser.add_argument('--walk_delta', help='walk delta', type=float, default=0.1)
    parser.add_argument('--hidden_att_dim', help='hidden_att_dim', type=int, default=64)
    # magnetic adaptive propagation plus
    parser.add_argument('--use_att', help='whether use attention', type=int, default=0)
