import re
from string import ascii_lowercase
from typing import List


def ordered_list(examples: List[str]) -> str:
    return '\n'.join(f'{i}. {e}' for i, e in enumerate(examples, start=1)).strip()


def unordered_list(items: List[str]) -> str:
    return '\n'.join(f'- {item}' for item in items).strip()


def simple_list(items: List[str]) -> str:
    return '\n'.join(items).strip()


def parse_list(text_list: str, separator: str = '-') -> List[str]:
    text_list = text_list.split('/n/n')[0]
    return [i.strip(separator).strip() for i in text_list.split('\n') if i.strip(separator).strip()]


def first_paragraph(text: str) -> str:
    return text.strip().split('\n')[0].strip()


def last_paragraph(text: str) -> str:
    return text.strip().split('\n')[-1].strip()


def clean_list_item(list_item: str) -> str:
    list_item = list_item.lower().strip()
    list_item = list_item.strip(',.')
    list_item = list_item.strip("'").strip('"').strip('[]')
    return list_item


def replace_brackets(template: str, replacer: str):
    return re.sub(r'\[[^)]*?\]', replacer, template)


def bracketed_items(text: str) -> List[str]:
    chunks = text.split('[')[1:]
    return sorted(list(set([chunk.split(']')[0] for chunk in chunks])))


def revariable_text(text: str):
    existing_vars = [chunk.split(']')[0] for chunk in text.split('[')[1:]]
    existing_vars = [v for i, v in enumerate(existing_vars) if v not in existing_vars[:i]]
    for var, c in zip(existing_vars, ascii_lowercase):
        text = re.sub(f'\[{var}\]', f'[tmp_{c}]', text)  # type: ignore
    for c in ascii_lowercase:
        text = re.sub(f'\[tmp_{c}\]', f'[{c}]', text)  # type: ignore
    return text

