"""Install lm-understanding-benchmark"""

import setuptools


def get_readme():
    """Fetch README from file."""
    with open("README.md", "r") as f:
        return f.read()


setuptools.setup(
    name="lm_understanding",
    version="0.0.1",
    description="Evaluation of Language Model Self-Knowledge",
    long_description=get_readme(),
    long_description_content_type="text/markdown",
    python_requires=">=3.8.0",
    packages=setuptools.find_packages(),
    install_requires=[
        "openai",
        "tqdm",
        "numpy",
        "matplotlib",
        "seaborn",
        "transformers==4.30.2",
        "datasets",
        "pandas",
        "tiktoken",
        "accelerate>=0.20.1",
        "sentence_transformers",
        "hydra-core==1.2",
        "protobuf<=3.20.1",
        "pytorch-lightning",
        "einops",
        "bitsandbytes",
        "nvidia-ml-py3",
        "safetensors",
    ],
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
    ],
)
