from lm_understanding.explanations.explanations import LocalExplanationSet
from lm_understanding.question_template import TemplateModelBehavior


def get_spamchar(char: str = 'a', spam_len: int = 500) -> str:
    assert len(char) == 1
    return char * spam_len


def create_spamchar(model_behavior: TemplateModelBehavior) -> LocalExplanationSet:
    assert model_behavior.template_id is not None
    train_questions, train_answers = model_behavior.questions('train'), model_behavior.answers('train')
    assert len(train_questions) == len(train_answers)
    explanations = [get_spamchar()] * len(train_questions)
    return LocalExplanationSet(model_behavior.template_id, train_questions, train_answers.tolist(), explanations)
