from lm_understanding.explanations.explanations import LocalExplanationSet
from lm_understanding.question_template import TemplateModelBehavior

from pathlib import Path
import pandas as pd


def get_path_wikibabble() -> Path:
    return Path('datasets/wikibabble.csv')


def create_wikibabble(model_behavior: TemplateModelBehavior) -> LocalExplanationSet:
    assert model_behavior.template_id is not None
    train_questions, train_answers = model_behavior.questions('train'), model_behavior.answers('train')
    assert len(train_questions) == len(train_answers)
    nsamples = len(train_questions)
    explanations = pd.read_csv(get_path_wikibabble()).random_page_summaries.sample(nsamples).to_list()
    return LocalExplanationSet(model_behavior.template_id, train_questions, train_answers.tolist(), explanations)
