import json
import shutil
from pathlib import Path


def main():
    task_dir = Path('datasets/unusual_reasoning')
    templates_per_topic = 20

    save_dir = task_dir / '_full_task'
    save_dir.mkdir(exist_ok=True, parents=True)

    all_templates = []
    for dir in task_dir.iterdir():
        task_name = dir.name
        if dir == save_dir:
            continue
        dir = next(dir.iterdir())
        templates = json.loads((dir / 'dataset.json').read_text())['templates']
        copied_templates = 0
        for template_dir in dir.iterdir():
            if not template_dir.is_dir():
                continue
            template_name = template_dir.name
            template = next(t for t in templates if t['template']['template_id'] == template_name)
            if template_name.startswith('template'):
                template_name = f"{task_name}{template_name.removeprefix('template')}"
            template['template']['template_id'] = template_name
            all_templates.append(template)
            shutil.copytree(template_dir, save_dir / template_name)
            copied_templates += 1
            if copied_templates >= templates_per_topic:
                break
    with open(save_dir / 'dataset.json', 'w') as f:
        json.dump(dict(templates=all_templates), f, ensure_ascii=False, indent=4)
    print(f'Dataset saved with {len(all_templates)} templates')

if __name__ == '__main__':
    main()