import json
from dataclasses import asdict
from pathlib import Path

from lm_understanding.question_template import load_question_templates

templates = load_question_templates(Path('templates/hiring_decisions/_combined/question_templates.json'))
for i, t in enumerate(templates):
    t.template_id = f'hiring_decisions_{i}'

with open(Path('templates/hiring_decisions/_combined/') / 'question_templates.json', 'w') as f:
    json.dump(dict(questions=[asdict(t) for t in templates]), f, indent=4, ensure_ascii=False)

