import json
from dataclasses import asdict
from pathlib import Path

from create_templates import parse_completion, save_templates

if __name__ == '__main__':
    template_dir = Path('templates/out_of_distribution/strange_hypotheticals/tough-disco-244')
    text_path = template_dir / 'tmp' / 'completions.txt'
    completions = text_path.read_text().split('}\n{')
    for i, c in enumerate(completions):
        c = c.strip()
        if c[0] != '{':
            c = '{' + c
        if c[-1] != '}':
            c = c + '}'
        completions[i] = c
    templates = []
    for completion in completions:
        templates.extend(parse_completion(completion))
    print(len(templates))
    with open(template_dir / 'question_templates.json', 'w') as f:
        json.dump(dict(questions=[asdict(t) for t in templates]), f, indent=4, ensure_ascii=False)

