# NeurIPS Submission – Bi-Directional Communication-Efficient Stochastic FL via Remote Source Generation

This repository contains the official implementation for our NeurIPS submission on **Bi-Directional Communication-Efficient Stochastic FL via Remote Source Generation**, supporting both **stochastic FL** and **conventional FL**. The experiments are implemented in **TensorFlow 2.15** and make use of **multiprocessing** for efficient large-scale simulation.

---

## 📦 Requirements

All dependencies are listed in the `requirements.yml` file (Conda environment) and was exported using

```bash
conda env export > reqs_mnist.yml
```

To set up the environment:

```bash
conda env create -f requirements.yml
conda activate <your-env-name>
```

---

## 🗂️ Code Overview

```
.
├── main.py                # Runs experiments for stochastic FL
├── main_cfl.py            # Runs experiments for conventional FL
├── comp.py                # Implements compression and quantization methods
├── mask_models.py         # Model definitions for stochastic FL (e.g., FedPM)
├── models.py              # Standard models for conventional FL
├── Training.py            # Local training loops for both FL types
├── Utils.py               # Utility functions (data creation, initialization, etc.)
├── Params/                # Parameter files for all experiments
├── requirements.yml       # Conda environment specification (includes pip packages)
└── README.md              # This file
```

---

## 🚀 Running Experiments

### ✅ Running All Experiments for a Dataset/Model

To run all predefined experiments (across seeds) for a given dataset, model, and data split (IID or Non-IID):

```bash
python main.py --dir Params/<dataset>_<model>/<IID|NonIID>
```

Omitting the seed will run multiple runs as specified in the corresponding parameter files (using run index as seed).

---

### 🧪 Running Stochastic Federated Learning with a Specific Seed

To run all experiments with a fixed seed:

```bash
python main.py --dir Params/<dataset>_<model>/<IID|NonIID> --seed <your-seed>
```

---

### 🎯 Running a Specific Experiment

To run a single parameter file:

```bash
python main.py --dir Params/<dataset>_<model>/<IID|NonIID> --include <experiment_file> --seed <your-seed>
```

For example:

```bash
python main.py --dir Params/MNIST_4CNN/IID --include glob_r_fixed_blocks_1_10 --seed 0
```

---

### ⚙️ Running Conventional Federated Learning

To run FL experiments with stochastic compression in the conventional (non-Bayesian) setting:

```bash
python main_cfl.py --dir Params/<dataset>_<model>/<IID|NonIID> --seed <your-seed>
```

The parameter files for conventional FL contain _sgd_ in their name.

---

## 🧠 Notes

- `main.py` is used for stochastic FL (i.e., FedPM).
- `main_cfl.py` is used for conventional FL with stochastic compression.
- If no seed is passed, multiple runs will be executed with seeds based on their run index.
- `multiprocessing` is used internally for parallel simulations—ensure sufficient system resources or disable.

---

## 📂 Experiment Organization

All experiments are defined under the `Params/` directory.

Each experiment group is organized as:

```
Params/<dataset>_<model>/<IID|NonIID>/
```

For example:

```
Params/FashionMNIST_4CNN/IID/
Params/CIFAR10_6CNN/NonIID/
```

Each folder contains multiple `.py` files specifying learning rates, batch sizes, model settings, number of runs, and other hyperparameters.

---

## 📊 Results

All results will be stored in the output directory "logs/" and logged through wandb. The result file name follows the convention from get_run_name() in Utily.py, which takes as input the config for the respective experiments. Check the code for logging customization if needed.

---

## 📄 License

This repository is provided for research and academic purposes only.
