# DARTS-

## Architecture Search

See `scripts/run_darts_minus.sh` for searching in S0-S4 (S0 corresponds to S5 in the code) on CIFAR-10 and CIFAR-100.

## Evaluation

See `scripts/run_darts_minus_fulltrain.sh` for the evaluation of CIFAR-100 models in all search spaces and CIFAR-10 models in S4. The rest CIFAR-10 models are evaluated with SGAS code in `script/eval`. 

## Hessian Eigenvalue Calculation

![](figures/hessian-c10-c100.png)

During the architecture search, we turn `--compute_hessian` off by default. Once the search is done, Hessian eigenvalues can be calculated independently from saved checkpoints.

See `scripts/start_calc_hessian.sh`.

## Loss Landscape

![](figures/loss-landscape-s3.png)

See `scripts/start_draw_loss_landscape.sh` for details.

## Acknowledgement

Code heavily borrowed from [DARTS](https://github.com/quark0/darts), [RobustDARTS](https://github.com/automl/RobustDARTS), [Loss Landscape](https://github.com/tomgoldstein/loss-landscape), and [SGAS]( https://github.com/lightaime/sgas). 