#!/bin/bash
#SBATCH --job-name=inference_3b2
#SBATCH --output=outputfinal/ablation_repsentations_all_plus.txt
#SBATCH --error=errorfinal/ablation_repsentations_all_plus.txt
#SBATCH --ntasks=1
#SBATCH --time=48:00:00
#SBATCH --mem=20Gb
#SBATCH --partition=main
#SBATCH -c 2
#SBATCH --gres=gpu:1 
#SBATCH --constraint=80gb



python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'agnews' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content


python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'dbpedia' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content


python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'sst2' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content

python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'trec' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content


python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'cb' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content


python processing_ablation_representation_final.py --fix_cls   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500   --include_answer --include_content
