#!/bin/bash
#SBATCH --job-name=inference_3b2
#SBATCH --output=output_final_15/1shot_ablation_repsentations_rte_structureauto_1shot_body.txt
#SBATCH --error=error_final_15/1_shot_ablation_repsentations_rte_structureauto_1shot_body.txt
#SBATCH --ntasks=1
#SBATCH --time=48:00:00
#SBATCH --mem=20Gb
#SBATCH --partition=long
#SBATCH -c 2
#SBATCH --gres=gpu:1 
#SBATCH --constraint=80gb

python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"    \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template --only_answer
# --random_string_seeds 5

python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"   \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template 

python processing_dataset_allrank_random_15.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500   --html_label "body"


python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template --only_answer




python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template 


python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500   --html_label "body"


python processing_ablation_representation_final15_more_random.py --fix_cls --random_template  --html_label "body" \
    --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template --only_answer

python processing_ablation_representation_final15_more_random.py --fix_cls --random_template  --html_label "body" \
    --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template 



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500   --html_label "body" --load_in_8bit

python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"   \
    --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template --only_answer

python processing_ablation_representation_final15_more_random.py --fix_cls --random_template --html_label "body"   \
    --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500     --include_answer --include_template 


python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'rte' \
    --num_seeds 15 \
    --all_shots 1 \
    --subsample_test_set 500   --html_label "body" --load_in_8bit