#!/bin/bash
#SBATCH --job-name=inference_3b2
#SBATCH --output=output_final_15/rep_diff_rte_withtoken_41_31.txt
#SBATCH --error=error_final_15/rep_diff_rte_withtoken_41_31.txt
#SBATCH --ntasks=1
#SBATCH --time=48:00:00
#SBATCH --mem=20Gb
#SBATCH --partition=long
#SBATCH -c 2
#SBATCH --gres=gpu:1 
#SBATCH --constraint=80gb



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 1 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated # --res_file './rep_save/open_llama_3b_12.res' 


python processing_compare_rankrep_compare_final_dec26.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 2 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated # --res_file './rep_save/open_llama_3b_11.res' 


python processing_compare_rankrep_compare_final_dec26.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'rte' \
    --num_seeds 3 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated # --res_file './rep_save/open_llama_3b_10.res' 



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 4 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated # --res_file './rep_save/llama-7b-hf_9.res' 


python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 5 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated # --res_file './rep_save/llama-7b-hf_10.res' 



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'rte' \
    --num_seeds 6 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_7.res'



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'rte' \
    --num_seeds 4 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_9.res' 


python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'rte' \
    --num_seeds 5 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_10.res' 



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'rte' \
    --num_seeds 6 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_7.res'





python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'rte' \
    --num_seeds 4 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_9.res' 


python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'rte' \
    --num_seeds 5 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_10.res' 



python processing_compare_rankrep_compare_final_dec26.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'rte' \
    --num_seeds 6 \
    --all_shots 4 \
    --subsample_test_set 500 --only_first_half_layers --rank_correlated --load_in_8bit # --res_file './rep_save/llama-7b-hf_7.res'