#!/bin/bash
#SBATCH --job-name=inference_3b2
#SBATCH --output=output/ablation_repsentations_mt_en2dan_main100.txt
#SBATCH --error=error/ablation_repsentations_mt_en2dan_main100.txt
#SBATCH --ntasks=1
#SBATCH --time=48:00:00
#SBATCH --mem=20Gb
#SBATCH --partition=main
#SBATCH -c 2
#SBATCH --gres=gpu:1 
#SBATCH --constraint=80gb


# Classify the news articles into the categories of World, Sports, Business, and Technology.
# Classify the text into World, Sports, Business, and Technology.
# Classify the articles based on whether they are in the categories of World, Sports, Business, and Technology.
# Classify the news to World, Sports, Business, and Technology.
# dan_Latn dan_Latn dan_Latn

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' \
    --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_content 


# without content tokens
python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_template # # --only_answer

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation --include_content


python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_content --include_template --without_punctuation # --only_answer



python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_content


# # without content tokens
python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_template # # --only_answer

python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation --include_content


python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_punctuation



python processing_ablation_representation_final15_text_generation.py --fix_cls  \
    --model 'decapoda-research/llama-7b-hf'  \
    --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
    --num_seeds 10 \
    --all_shots 4 \
    --subsample_test_set 100   --include_answer --include_content --include_template --without_punctuation # --only_answer












# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template --without_punctuation # --only_answer






# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit  \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template --without_punctuation # --only_answer



    
# python processing_dataset_allrank.py \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 1 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_punctuation


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer






# # with content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 3 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# # with template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 3 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer


# # without template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 3 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content

# # with punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 3 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# # without punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'EleutherAI/gpt-j-6b' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 3 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer







# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 4 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer
# # python processing_dataset_allrank.py \
# #     --model 'decapoda-research/llama-7b-hf' \
# #     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
# #     --num_seeds 1 \
# #     --all_shots 4 \
# #     --subsample_test_set 100   --include_punctuation


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 5 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer






# # with content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# # with template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer


# # without template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content

# # with punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# # without punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-7b-hf' \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 6 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer






# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 7 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer
# python processing_dataset_allrank.py \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 1 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_punctuation


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 8 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer






# with content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # # --only_answer

# # with template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # # --only_answer


# # without template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content

# # with punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# without punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-13b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 9 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # # --only_answer






# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 10 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer
# # python processing_dataset_allrank.py \
# #     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
# #     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
# #     --num_seeds 1 \
# #     --all_shots 4 \
# #     --subsample_test_set 100   --include_punctuation


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content


# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 11 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer






# # with content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content


# # without content tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_template # --only_answer

# # with template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_template # --only_answer


# # # without template tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation --include_content

# # with punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_punctuation

# # without punctuation tokens
# python processing_ablation_representation_final15_text_generation.py --fix_cls  \
#     --model 'decapoda-research/llama-30b-hf' --load_in_8bit \
#     --dataset 'facebook/flores' --lang1 eng_Latn --lang2 dan_Latn \
#     --num_seeds 12 \
#     --all_shots 4 \
#     --subsample_test_set 100   --include_answer --include_content --include_template # --only_answer