#!/bin/bash
#SBATCH --job-name=inference_3b2
#SBATCH --output=output_final_15/allrank_result_dbpedia_random_more_random_sup.txt
#SBATCH --error=error_final_15/allrank_result_dbpedia_random_more_random_sup.txt
#SBATCH --ntasks=1
#SBATCH --time=48:00:00
#SBATCH --mem=20Gb
#SBATCH --partition=main
#SBATCH -c 2
#SBATCH --gres=gpu:1 
#SBATCH --constraint=80gb


python processing_dataset_allrank_random_15.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --fixed_random



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --fixed_random




python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --fixed_random --load_in_8bit



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --fixed_random --load_in_8bit




python processing_dataset_allrank_random_15.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --nonfixed_random



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --nonfixed_random



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --nonfixed_random --load_in_8bit


python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --nonfixed_random --load_in_8bit



python processing_dataset_allrank_random_15.py \
    --model 'openlm-research/open_llama_3b' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --same_random



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-7b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --same_random





python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-13b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --same_random --load_in_8bit



python processing_dataset_allrank_random_15.py \
    --model 'decapoda-research/llama-30b-hf' \
    --dataset 'dbpedia' \
    --num_seeds 15 \
    --all_shots 4 \
    --subsample_test_set 500 --random_string_seeds 5 --same_random --load_in_8bit

