# LaDEEP
This is the implement of "LaDEEP: A Deep Learning-based Surrogate Model for Large Deformations of Elastic-Plastic Solids"

## Usage

We recommend that `python>=3.10`.

### Install packages

```
cd ./LaDEEP
pip install -r ./requirements.txt
```

### Dataset

The dataset is large and cannot submit by supplement. We upload it on the Internel. [Download](https://drive.google.com/drive/folders/1DJCi74Gg3d4cBv1JlUG1pmyS1pVo2mJm?usp=sharing) the data,  extract it and put it in the `./data` folder. You can also change the data folder whatever you want in `./config.ini` file.

### Train

Several hyperparameters are recorded in `./config.ini` file. You can change them to train the model. The default settings are corresponding to those used in the paper.

Then use the below command to start the train:

```
mkdir ./checkpoints
mkdir ./logs

# Display training process on the frontend
python main.py

# Display training process on the backend
nohup python main.py >> ./train.log 2>&1 &
```

The training and evaluation losses are illustrated by `tensorboard`:

```
tensorboard --logdir ./logs --port 8888
```

Then you can monitor the training and evaluation details by open `localhost:8888` on your browser.

### Test

We have provided model weights in `./checkpoints/train_0` folder.

To test the model, we first need to change the mode in `config.ini`:

```
mode = test
```

and the `mode_id` is the folder `./checkpoints/train_{mode_id}` where saves the checkpoints you wanna use. Then test the model:

```
python main.py
```

and the results, MAD and TE will be save in `./data/prediction_results/test_{mode_id}`. 

If you want to calculate IoU 3D, you need to install [Siemens NX](https://plm.sw.siemens.com/en-US/nx/). Then add the fold where saves prediction results to `root` list in  `./scripts/iou_3d/iou_3d_eval.py` and play the file by utilizing NX's playback function.
