# RainDiff
Official implementation of "[RainDiff: End to End Precipitation Nowcasting Via Token-wise Attention Diffusion]"

## Introduction

Precipitation nowcasting, predicting future radar echo sequences from current observations, is a critical yet challenging task due to the inherently chaotic and tightly coupled spatio-temporal dynamics of the atmosphere. While recent advances in diffusion-based models attempt to capture both large-scale motion and fine-grained stochastic variability, they often suffer from scalability issues: latent-space approaches require a separately trained autoencoder, adding complexity and limiting generalization, while pixel-space approaches are computationally intensive and often omit attention mechanisms, reducing their ability to model long-range spatio-temporal dependencies. To address these limitations, we propose a Token-wise Attention integrated into not only the U-Net diffusion model but also the spatio-temporal encoder that dynamically captures multi-scale spatial interactions and temporal evolution. Unlike prior approaches, our method natively integrates attention into the architecture without incurring the high resource cost typical of pixel-space diffusion, thereby eliminating the need for separate latent modules. Our extensive experiments and visual evaluations across diverse datasets demonstrate that the proposed method significantly outperforms state-of-the-art approaches, yielding superior local fidelity, generalization, and robustness in complex precipitation forecasting scenarios.

This repository contains the part of training code for using RainDiff on SEVIR datasets. 

## Code

### Environment

```shell
conda env create -f env.ymal
conda activate raindiff
```

### Training
```shell
sh script.sh
```
## Acknowledgement

We refer to implementations of DiffCast and sincerely thank their contribution for the community:

```
@inproceedings{Yu2024diffcast,
  title={DiffCast: A Unified Framework via Residual Diffusion for Precipitation Nowcasting},
  author={Demin Yu and Xutao Li and Yunming Ye and Baoquan Zhang and Chuyao Luo and Kuai Dai and Rui Wang and Xunlai Chen},
  booktitle={The IEEE/CVF Conference on Computer Vision and Pattern Recognition},
  year={2024}
}
```