

tb1 <- list()
tb2 <- list()
for (simu in 1:10) {
  fileFedEM <-
    paste('~/GMM_synthet_server/results/FedEM_traj_normH_simu',
          simu,
          '.txt',
          sep = "")
  fileFedSpidEM <-
    paste('~/GMM_synthet_server/results/FedSpidEM_traj_normH_simu',
          simu,
          '.txt',
          sep = "")
  tb1[[simu]] <- read.table(fileFedEM)$x
  tb2[[simu]] <- read.table(fileFedSpidEM)$x
}
mat1 <- do.call(rbind, tb1)
mat2 <- sapply(tb2, function(x) x[1:5000])

library(matrixStats)
quant1 <- colQuantiles(mat1, probs = 0.25)
quant2 <- rowQuantiles(mat2, probs = 0.25)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

library(latex2exp)
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
plot(
  seq(1, nb_epoch_Spid, length.out = nrow(mat2)),
  quant2,
  col = "red",
  type = "l",
  log = "y",
  xlab = "Epoch",
  ylab = TeX('$||H^k||^2$'),
  cex.main = 2,
  cex.lab = 2,
  cex.axis = 2,
  ylim=c(min(mat2),max(mat1))
)
lines(seq(1, nb_epoch_Fed, length.out = ncol(mat1)),
      quant1,
      type = "l",
      col = "blue")
legend("bottomleft",  legend=c("FedEM", "VR-FedEM"), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)


library(matrixStats)
mean1 <- colMeans(mat1)
mean2 <- rowMeans(mat2)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

library(latex2exp)
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
plot(
  seq(1, nb_epoch_Spid, length.out = nrow(mat2)),
  mean2,
  col = "red",
  type = "l",
  log = "y",
  xlab = "Epoch",
  ylab = TeX('$||H^k||^2$'),
  cex.main = 2,
  cex.lab = 2,
  cex.axis = 2,
  ylim=c(min(mat2),max(mat1))
)
lines(seq(1, nb_epoch_Fed, length.out = ncol(mat1)),
      mean1,
      type = "l",
      col = "blue")
legend("bottomleft",  legend=c("Fed EM", "Fed SPIDER-EM"), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1)




