## FedEM ##

tb1 <- list()
tb2 <- list()
cnt <- 1
for (prob in c(0.75)) {
  fileFedEM <-
    paste('~/GMM_synthet_PP/results/FedEM_traj_normH_prob', 100*prob,
          '.txt',
          sep = "")
  fileFedEM_h <-
    paste('~/GMM_synthet_PP/results/FedEM_traj_normh_prob', 100*prob,
          '.txt',
          sep = "")
  tb1[[cnt]] <- read.table(fileFedEM)$x
  tb2[[cnt]] <- read.table(fileFedEM_h)$x
  cnt <- cnt+1
}

mat1 <- do.call(rbind, tb1)
mat2 <- do.call(rbind, tb2)

library(matrixStats)
quant1 <- colQuantiles(mat1, probs = 0.5)
quant2 <- colQuantiles(mat2, probs = 0.5)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

library(latex2exp)
# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
plot(seq(1, 500, length.out=length(mat1[1,])),
     mat1[1,],
     col = "red",
     type = "l",
     log = "y",
     xlab = "Epoch",
     ylab = "",
     cex.main = 2,
     cex.lab = 2,
     cex.axis = 2,
     ylim=c(min(tb2[[1]]),max(tb2[[1]]))
)
lines(seq(1, 500, length.out=length(mat2[1,])),
      mat2[1,],
      type = "l",
      col = "blue")
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)


quant1 <- colQuantiles(mat1, probs = 0.25)
quant2 <- colQuantiles(mat2, probs = 0.25)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 2000, length.out=length(tb1[[1]])),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 2000, length.out=length(tb2[[1]])),
      quant2,
      type = "l",
      col = alpha("blue", 0.2))
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)

quant1 <- colQuantiles(mat1, probs = 0.75)
quant2 <- colQuantiles(mat2, probs = 0.75)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)


# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 2000, length.out=length(tb1[[1]])),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 2000, length.out=length(tb2[[1]])),
      quant2,
      type = "l",
      col = alpha("blue", 0.2))
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)

## FedSpidEM ##
# FedSpidEM field h and random field H
tb1 <- list()
tb2 <- list()
cnt <- 1
for (synth in 1:5) {
  for(simu in 1:5){
    fileFedEM <-
      paste('~/GMM_synthet_PP/results/FedSpidEM_traj_normH_prob75',
            '.txt',
            sep = "")
    fileFedEM_h <-
      paste('~/GMM_synthet_PP/results/FedSpidEM_traj_normh_prob75',
            '.txt',
            sep = "")
    tb1[[cnt]] <- read.table(fileFedEM)$x
    tb2[[cnt]] <- read.table(fileFedEM_h)$x
    cnt <- cnt+1
    
  }
}

mat1 <- t(sapply(tb1, function(x) x[1:5000]))
mat2 <- t(sapply(tb2, function(x) x[1:5000]))

library(matrixStats)
quant1 <- colMeans(mat1, na.rm=T)
quant2 <- colMeans(mat2, na.rm=T)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

library(latex2exp)
# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
plot(seq(1, 1000, length.out=length(mat1[1,])),
     mat1[1,],
     col = "red",
     type = "l",
     log = "y",
     xlab = "Epoch",
     ylab = "",
     cex.main = 2,
     cex.lab = 2,
     cex.axis = 2,
     ylim=c(1e-20,5)
)
lines(seq(1, 1000, length.out=length(mat2[1,])),
      mat2[1,],
      lty="dashed",
      col = "blue")
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty=c("dashed", "solid"),
       lwd = 2,
       cex=1.5)


quant1 <- lapply(1:5, function(i) colQuantiles(mat1[(1+(i-1)*5):(i*5),], probs=0.25, na.rm=T))
quant1 <- colMeans(do.call(rbind, quant1), na.rm=T)
quant2 <- lapply(1:5, function(i) colQuantiles(mat2[(1+(i-1)*5):(i*5),], probs=0.25, na.rm=T))
quant2 <- colMeans(do.call(rbind, quant2), na.rm=T)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 1000, length.out=length(quant1)),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 1000, length.out=length(quant2)),
      quant2,
      lty="dashed",
      col = alpha("blue", 0.2))


quant1 <- lapply(1:5, function(i) colQuantiles(mat1[(1+(i-1)*5):(i*5),], probs=0.75, na.rm=T))
quant1 <- colMeans(do.call(rbind, quant1), na.rm=T)
quant2 <- lapply(1:5, function(i) colQuantiles(mat2[(1+(i-1)*5):(i*5),], probs=0.75, na.rm=T))
quant2 <- colMeans(do.call(rbind, quant2), na.rm=T)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)


# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 1000, length.out=length(quant1)),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 1000, length.out=length(quant2)),
      quant2,
      lty="dashed",
      col = alpha("blue", 0.2))


## Naive EM ##

tb1 <- list()
tb2 <- list()
cnt <- 1
for (synth in 2) {
  for(simu in 2){
    filenaiveEM <-
      paste('~/GMM_synthet_compression/results/naiveEM_traj_normH_synth', synth, '_simu',
            simu,
            '.txt',
            sep = "")
    filenaiveEM_h <-
      paste('~/GMM_synthet_compression/results/naiveEM_traj_normh_synth', synth, '_simu',
            simu,
            '.txt',
            sep = "")
    tb1[[cnt]] <- read.table(filenaiveEM)$x
    tb2[[cnt]] <- read.table(filenaiveEM_h)$x
    cnt <- cnt+1
    
  }
}

mat1 <- do.call(rbind, tb1)
mat2 <- do.call(rbind, tb2)

library(matrixStats)
quant1 <- colQuantiles(mat1, probs = 0.5)
quant2 <- colQuantiles(mat2, probs = 0.5)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

library(latex2exp)
# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
plot(seq(1, 2000, length.out=length(mat1)),
     mat1,
     col = "red",
     type = "l",
     log = "y",
     xlab = "Epoch",
     ylab = "",
     cex.main = 2,
     cex.lab = 2,
     cex.axis = 2,
     ylim=c(min(tb2[[1]]),max(tb2[[1]]))
)
lines(seq(1, 2000, length.out=length(mat2)),
      mat2,
      type = "l",
      col = "blue")
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)


quant1 <- colQuantiles(mat1, probs = 0.25)
quant2 <- colQuantiles(mat2, probs = 0.25)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)

# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 2000, length.out=length(tb1[[1]])),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 2000, length.out=length(tb2[[1]])),
      quant2,
      type = "l",
      col = alpha("blue", 0.2))
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)

quant1 <- colQuantiles(mat1, probs = 0.75)
quant2 <- colQuantiles(mat2, probs = 0.75)
nb_epoch_Spid <- 2 * 250 
nb_epoch_Fed <- round(2000 * 1e4 / 1e4)


# FedEM field h and random field H
op <- par(no.readonly = TRUE)
par(mar = c(5, 6, 2, 2))
options(repr.plot.width=8, repr.plot.height=6)
lines(seq(1, 2000, length.out=length(tb1[[1]])),
      quant1,
      col = alpha("red", 0.2))

lines(seq(1, 2000, length.out=length(tb2[[1]])),
      quant2,
      type = "l",
      col = alpha("blue", 0.2))
legend("topright",  legend=c(TeX('$||h(S^k)||^2$'), TeX('$||H^k||^2$')), 
       col=c("blue", "red"),
       lty="solid",
       lwd = 2,
       cex=1.5)
