# Code for ShEPhERD and its evaluations
This is not the final version of the code, but a curated version for review.

# Note on anonymization
**We guarantee that all author-identifying information has been removed from this repository to ensure anonymity.** Please note that this repository *has* copied existing public repositories (e.g., EquiformerV2, E3NN, OCP models) for user convenience, and these public repositories do contain information regarding their respective authors (e.g., in their licenses). **Such information is not to be interpreted as relating to the authors of this new submission.**


# Model information
Please go to `shepherd_model/README.md` for more information and example scripts


# Evaluation information

### ShEPhERD Scoring Functions
These are provided in `shepherd-score` and is a directory separate from the `shepherd_model`.
It requires local installation for use as listed below.

This directory contains the scoring functions used as well as the evaluations.

Minimal working examples for consistency and conditional evaluations are found in `example_eval.ipynb` using smaller samples of our data to remain under the 100MB limit.


#### Requirements for shepherd-score
```
python >=3.8
numpy >1.2, <2.0
pytorch >=1.12
open3d >=0.18
rdkit >=2023.03
xtb >=6.6 (Use conda)
```

Optional
```
jax==0.4.26
jaxlib==0.4.26+cuda12.cudnn89
optax==0.2.2
py3dmol==2.1.0
```

#### Installation of shepherd_score
1. Clone this repo
2. Navigate to this repo's top-level directory
3. Create or use a generic conda environment and activate it
4. Install xtb with `conda install -c conda-forge xtb`
5. Run `pip install -e .` for developer install (this will automatically install numpy, pytorch, open3d, and rdkit)