# Example data
Examples of different data we use for evaluations.

- `moses_aq_sampled_molblock_charges.pkl`
    - Contains 45 examples from the ShEPhERD-MOSES-aq dataset stored as a list of tuples containing molblocks (str) and partial charges (list(float))

- `gdb17_sampled_molblock_charges.pkl`
    - Contains 45 examples from the ShEPhERD-GDB17 dataset stored as a list of tuples containing molblocks (str) and partial charges (list(float))

- `gdb17_x3_uncond_samples.pickle`
    - Contains a list of dictionaries of ShEPhERD-generated samples from the P(x1, x3) unconditional distribution after being trained on GDB17

- `gdb17_x3_cond_samples.pickle`
    - Contains a list of np.arrays and the final element contains a list of dictionaries of ShEPhERD-generated samples from the P(x1 | x3) conditional distribution after being trained on GDB17

The structure of the samples's dictionaries of generated samples are:
```python
{
    'x1': {
        'atoms': np.array,
        'positions': np.array
    },
    'x2': {
        'positions': np.array,
    },
    'x3': {
        'positions': np.array,
        'charges': np.array
    },
    'x4': {
        'types': np.array,
        'positions': np.array,
        'directions': np.array
    }
}
```