#!/bin/bash

# -------- Constraint Experiments -------- #
# Adult non-private
python run_constraint_program_benchmark.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels
python run_constraint_program_benchmark.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels --baseline_mode
# Adult private
python run_constraint_program_benchmark.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three --epsilon 1.0
python run_constraint_program_benchmark.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three --epsilon 1.0 --baseline_mode
# Adult rejection sampling
python run_constraint_program_rejection_sampling_baseline.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels
python run_constraint_program_rejection_sampling_baseline.py --dataset ADULT --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three --epsilon 1.0
# Adult Ablation
python run_adult_ablation.py --option 1 --n_samples 5 --n_resamples 5 --random_seed 42
python run_adult_ablation.py --option 1 --n_samples 5 --n_resamples 5 --random_seed 42 --baseline_mode
python run_adult_ablation.py --option 2 --n_samples 5 --n_resamples 5 --random_seed 42
python run_adult_ablation.py --option 2 --n_samples 5 --n_resamples 5 --random_seed 42 --baseline_mode
# Health Heritage
python run_constraint_program_benchmark.py --dataset HealthHeritage --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels
python run_constraint_program_benchmark.py --dataset HealthHeritage --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels --baseline_mode
# Health Heritage rejection sampling
python run_constraint_program_rejection_sampling_baseline.py --dataset HealthHeritage --n_samples 5 --n_resamples 5 --random_seed 42 --workload all_three_with_labels

# ------ Run the unconstrained experiments shown in Appendix D ------ # 
# DP with epsilon = 1.0
python train_programmable_synthesizers_dp.py --dataset ADULT --n_samples 5 --workload all_three --single_setup --epsilon 1.0 --random_seed 42
python run_dp_benchmark_evals.py --dataset ADULT --algorithm ProgSyn --workload all_three --n_samples 5 --n_resamples 5 --random_seed 42
python train_programmable_synthesizers_dp.py --dataset HealthHeritage --n_samples 5 --workload all_three --single_setup --epsilon 1.0 --random_seed 42
python run_dp_benchmark_evals.py --dataset HealthHeritage --algorithm ProgSyn --workload all_three --n_samples 5 --n_resamples 5 --random_seed 42
# Non-private
python train_programmable_synthesizers_non_dp.py --dataset ADULT --n_samples 5 --workload all_three_with_labels --random_seed 42
python run_non_dp_benchmark_evals.py --dataset ADULT --model ProgSyn --n_samples 5 --n_resamples 5 --workload all_three_with_labels --random_seed 42
python train_programmable_synthesizers_non_dp.py --dataset HealthHeritage --n_samples 5 --workload all_three_with_labels --random_seed 42
python run_non_dp_benchmark_evals.py --dataset HealthHeritage --model ProgSyn --n_samples 5 --n_resamples 5 --workload all_three_with_labels --random_seed 42
