import numpy as np
import torch
from tabular_datasets import HealthHeritage


random_seed = 42
ratio = 0.2

# set the random seed
np.random.seed(random_seed)
torch.manual_seed(random_seed)

dataset = HealthHeritage(random_state=random_seed)

Xtrain, ytrain = dataset.get_Xtrain().cpu().numpy(), dataset.get_ytrain().cpu().numpy()
Xtest, ytest = dataset.get_Xtest().cpu().numpy(), dataset.get_ytest().cpu().numpy()

np.save(f'tabular_datasets/Health_Heritage/presplit_xtrain_{ratio}_{random_seed}.npy', Xtrain)
np.save(f'tabular_datasets/Health_Heritage/presplit_ytrain_{ratio}_{random_seed}.npy', ytrain)

np.save(f'tabular_datasets/Health_Heritage/presplit_xtest_{ratio}_{random_seed}.npy', Xtest)
np.save(f'tabular_datasets/Health_Heritage/presplit_ytest_{ratio}_{random_seed}.npy', ytest)


