# Requirements
All of requirements are included in requirements.txt and can be installed as
```bash
pip install -r requirements.txt
```

 
We use IPython 7.7.0  on Ubuntsu 18.04 environment.

  
------------------------------------
# Create Dataset
Please download the CelebA dataset from the bellowing link.
http://mmlab.ie.cuhk.edu.hk/projects/CelebA.html

Then, image should be center cropped with the size of 64x64 with 'center_celeba.py'.
Edit line 10 in this file to the directory you unzip the CelebA dataset.
Also edit line 16 to name the directory you want to store cropped images.
```bash
ipython center_celeba.py
```

# Run Experiments 

Execution code is "vae_tfcoding_CelebA.py". Run the script 'CelebA.sh' to train model and statical analysis.   
Before runnin the script, please edit "img=../../../data/CelebA/centered_celeba_64_all" to be directory where you located center cropped image.
```bash
sh CelebA.sh
```

Then, the result will be created in the directory "CelebA_nosp/z${z}_lambda${lambda}" or  "CelebA_sp/z${z}_lambda${lambda}" .
nosp means the loss function is standard form of VAE. 
sp means the explicitly decomposed loss is used. 

In the directory, the following statictics csv files and plot graphs are generated.

- VAE_rec__dist_z${z-1}_s_hakohige_delta0.01.csv: Statics file.  
	- column 1:  The averge of D'(z_j). D'(z_j) is a partial derivertive of dx_/dzj  
	- column 2:  The standard deviation of D'(z_j)
- VAE_rec__dist_z${z-1}_s_hakohige_delta0.01_with_sigma.csv: Statics file.  
	- column 1:  The averge of {\sigma}_j^{-2} D'(z_j).  By multipling 2{\lambda} to the first column, they become close to 1. 
	- column 2:  The standard deviation of {\sigma}_j^{-2} D'(z_j).  By multipling 2{\lambda} to the first column, their scale is the same as the estimated norm.
- VAE_variance_df_.csv: The variance of {\z_j}. 
- VAE_variance_df_inv_sigma2_.csv: The average of {\sigma_j}^{-2}
- VAE_rec__sample_t_sigma${i}.png: The latent traverse of z_{9*(i-1)}~z_{9*(i-1)+9}

  