import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
import numpy.random as rnd
from scipy import io, stats

data_dim = 3
datanum=50000
pn_dim = 16

np.random.seed(seed=0)


def tri3(dim):
#    x = np.random.uniform(3)*np.array([1,2,4])
    mu = np.array([0,0,0])
    sigma = np.array([[1.0/6.0,0,0],[0,4.0/6.0,0],[0,0,16.0/6.0]])
    x = np.random.multivariate_normal(mu, sigma)
    pdfs = stats.multivariate_normal(mu, sigma).pdf(x)
    x = np.append(x, pdfs)
    return x


for i in range(datanum):
    if i == 0:
        samples=tri3(3)
    else:
        samples = np.vstack((samples, tri3(3)))


mu1 = 0
mu2 = 15
mu3 = 15

sig1= 1
sig2= 2
sig3= 3


data1 = rnd.normal(mu1 ,np.sqrt(sig1),(datanum,3))

mean1=[mu1,mu1,mu1]
conv1 =[
    [sig1, 0, 0],
    [0, sig1, 0],
    [0, 0, sig1],
]

pdfs = stats.multivariate_normal(mean1, conv1).pdf(data1)
#print(z2[0:10])


pn = np.load('pn1.npy') - 0.5

D12 =np.dot(pn[0][:pn_dim-1], pn[1][:pn_dim-1])
D13 =np.dot(pn[0][:pn_dim-1], pn[2][:pn_dim-1])
D23 =np.dot(pn[1][:pn_dim-1], pn[2][:pn_dim-1])

x1 = np.sqrt(abs(D12*D13/D23)) - 0.5
x2 = np.sqrt(abs(D12*D23/D13))
x3 = np.sqrt(abs(D13*D23/D12))

pn[0][-1] = x1
pn[1][-1] = x2
pn[2][-1] = x3
pn[0] -= np.mean(pn[0][:pn_dim])
pn[1] -= np.mean(pn[1][:pn_dim])
pn[2] -= np.mean(pn[2][:pn_dim])
pn[0] /=np.sqrt(np.dot(pn[0][:pn_dim],pn[0][:pn_dim]))
pn[1] /=np.sqrt(np.dot(pn[1][:pn_dim],pn[1][:pn_dim]))
pn[2] /=np.sqrt(np.dot(pn[2][:pn_dim],pn[2][:pn_dim]))


from scipy.stats import pearsonr

toys = []
pdfs = []
#samples = []
for l in range(datanum):
    #print(l)
    data_tmp = samples[l]
    v_tmp = np.zeros(pn_dim)
    for i in range(0, 3 , 1):
        v_tmp += pn[i] * data_tmp[i]
    toys.append(v_tmp)
    pdf = data_tmp[3]

    pdfs.append(pdf)

toys = np.array(toys)

fw = open('norm3_pn.csv', 'w')
for l in range(datanum):
    for i in range(pn_dim):
        fw.write(str(toys[l][i])+',')
    fw.write(str(pdfs[l]) + '\n')

fw.close()

