# Towards Robust Multi-modal Reasoning via Model Selection
## Usage
### Requirements
The $M^3$ framework depends on the following main requirements:
- networkx==2.8.4
- numpy==1.23.1
- torch==1.13.1+cu117
- torch_geometric==2.3.1
- tqdm==4.64.0

### How to Run


For simple one-time running with default hyperparameters:
```
python run_m3.py --backbone gat --loss cce --encoder blip --seed 1
```
For baseline NCF and NCF++:
```
python run_ncf.py --loss cce --encoder blip --seed 1
python run_ncf++.py --loss cce --encoder blip --program_encoder bert --seed 1
```
For multiple complex hyper-parameter tuning experiments in $M^3$, simply do:
```
sh run.sh
```
Note, you can freely change the range of hyperparameter values according to your needs in [`run.sh`]().

### Reproducibility
We recently found that inherent randomness in certain PyG sub-libraries causes variability in experimental results (see [link](https://github.com/pyg-team/pytorch_geometric/issues/3175)). This variation does not impact the conclusions in our paper but results in minor fluctuations. If you have better solutions, feel free to reach out anytime 👏.


